// Copyright 1994 by Jon Dart.  All Rights Reserved.

#ifndef _MATERIAL_H
#define _MATERIAL_H

#include "types.h"
#include "piece.h"

class Material
{
	friend class Board;
public:
	Material()
	{
		info = total = 0;
	}
	
	void add_piece(const Piece::PieceType);

	void remove_piece(const Piece::PieceType);

	// return the number of pieces of the given type:
	unsigned count(const Piece::PieceType) const;

	// return the total material value:
	uint16 value() const
	{
		return total;
	}
	
	uint16 infobits() const
	{
		return info;
	}
	
	// return the total number of pieces (excluding pawns and king)
	unsigned piece_count() const;

	// True if only king and pawns:
	BOOL no_pieces() const
	{
		return (info & 0x7ff8) == 0;
	}
	
	// True if bare king:
	BOOL king_only() const
	{
		return (info & 0x7fff) == 0;
	}
	
private:
	void clear();

	uint16 total;
	int16 info;
};

#endif

